<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="../css/all.css" rel="stylesheet" type="text/css" />
    <link href="../css/bootstrap.css" rel="stylesheet" id="bootstrap-css">
    <link href="../css/alert.css" rel="stylesheet" id="alert-css">
    <link href="../css/custom.css" rel="stylesheet" id="custom-css">
    <link href="../css/master.css" rel="stylesheet" id="master-css">
    <title>SMS Mailer</title>
</head>
<body>
<input type="checkbox" name="nav-toggle" id="nav-toggle">
    <div class="sidebar">
        <div class="sidebar-brand">
            <h2>
                <i class="fas fa-warehouse"></i><span>Jozibeck</span>
            </h2>
        </div>

        <?php require_once("sidebar.txt"); ?>
    </div>

    <div class="main-content">
        <div class="header">
            <h2>
                <label for="nav-toggle">
                    <i class="fas fa-bars"></i>
                </label>
                SMS Mailer
            </h2>

            <div class="search-wrapper">
               <i class="fas fa-search"></i>
                <input type="text" name="search" id="search" placeholder="Search here ...">
            </div>

            <div class="balance-wrapper">
                <h6>Balance</h6>
                <h4>0.00</h4>
            </div>

            <div class="user-wrapper">
                <img src="../images/user_profiles/1.jpg"  height="40px" width="40px"alt="">
                <div>
                    <h4>Jozibeck Properties Ltd</h4>
                    <small>Super Admin</small>
                </div>
            </div>
        </div>
        <main>
            <div class="row mt-2">            
                <div class="col col-md-4">
                    <h6>Step 1: Choose Tenants</h6>
                    <div class="row mb-2">
                        <div class="col col-md-4">
                            <label class="control-label" for="propertyowner">Property Owner:</label> 
                        </div>
                        <div class="col">
                            <select name="propertyowner" id="propertyowner" class="form-control form-control-sm"></select>
                        </div>
                    </div>

                    <div class="row mb-2">
                        <div class="col col-md-4"> 
                            <label for="propertyname">Property Name: </label>
                        </div>
                        <div class="col">
                            <select name="" id="propertyname" class="form-control form-control-sm"></select>
                        </div>
                    </div>

                    <div class="scrollablelist" id="customerslist"></div>
                    <div class="check-group">
                        <input type="checkbox" class="check-control" id="selectall" name="selectall">
                        <label for="selectall" class="check-label ml-1 mt-2">Select All</label>
                    </div>
                </div>
                <div class="col col-md-8">
                    <h6>Step 2: Choose Template</h6>
                    <div id="errors" class="mt-1 mb-1"></div>
                    <div class="form-inline form-group">
                        <label for="template" class="mr-2">Select Template</label>
                        <select name="template" id="template" class="form-control form-control-sm"></select>
                    </div>

                    <div class="form-group">
                        <label for="smsbody">SMS Body</label>
                        <textarea name="smsbody" id="smsbody" cols="30" rows="10" class="form-control form-control-sm"></textarea>
                    </div>
                    <button class="btn btn-sm btn-success" id="sendsms">Send SMS</button>
                    <button class="btn btn-sm btn-secondary" id="previewsms">Preview SMS</button>
                </div>
            </div>
        </main>
    </div>
    <!-- End of Template -->
</body>
<script src="../js/jquery-2.2.4.js"></script>
<script src="../js/alert.js"></script>
<script src="../js/functions.js"></script>
<script src="../js/smsmailer.js"></script>
</html>