<?php
    require_once("db.php");
    class sms extends db{
        private $apikey;
        private $senderid;
        private $clientid;
        private $url;
        private $apiused;
        private $token;

        public function __construct(){
            // get uwazi parameters from the database
            $sql="CALL sp_getuwazismsparameters ()";
            $data=$this->getData($sql)->fetch();
            $this->apikey=$data['apikey'];
            $this->senderid=$data['senderid'];
            $this->clientid=$data['clientid'];
            $this->url=$data['url'];
            $this->apiused=$data['apiused'];
            $this->token=$data['token'];
        }

        public function sendSMS($recipient,$message){
            // encode message to replace spaces with %20
            $message=urlencode($message);
            if($this->apiused=='old'){
                $redirecturl  =$this->url."?ApiKey=".$this->apikey;
                $redirecturl .="&ClientId=".$this->clientid;
                $redirecturl .="&SenderId=".$this->senderid;
                $redirecturl .="&Message=".$message;
                $redirecturl .="&MobileNumbers=".$recipient;
            }else{
                //https://api2.uwaziimobile.com/send?token=wJd8mN14re5AM7gQt0S46MfKRJhdBW&phone=254727709772&senderID=Wavishaji&text=Hello%20world%21&type=sms&lifetime=86400&beginDate=2022-10-01&beginTime=15%3A07%3A15&delivery=TRUE
                $redirecturl  =$this->url."?token=".$this->token;
                $redirecturl .="&senderID=".$this->senderid;
                $redirecturl .="&phone=".$recipient;
                $redirecturl .="&text=".$message;
            }

            $ch=curl_init();
            $headers=['Content-Type:application/json'];
            
            curl_setopt($ch, CURLOPT_URL, $redirecturl);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

            $response=curl_exec($ch);
            $response= json_decode($response, true);
            curl_close($ch);
            //return $response;

              // echo $response;
            if ($this->apiused=='new'){
                // echo json_encode($status);
                if(array_key_exists($recipient,$status)){
                    // $messagestatus="success";
                    $messagedescription="";
                    $messageid=$status[$recipient];
                    $messagestatus='Sent';
                }else{
                    // $messagestatus=$status['errors'];
                    $errordescription=$status['error'];
                    $messageid="";
                    $messagestatus="Pending";
                }
            }else{
                $errorcode = $status['ErrorCode'];
                if($errorcode==0){ 
                    $messagedescription=$status['Data'][0]['MessageErrorDescription'];
                    $messageid=$status['Data'][0]['MessageId'];
                    $messagestatus='Sent';
                }else{
                    $messageid="";
                    $messagestatus='Pending';  
                    $errordescription=$status['ErrorDescription']; 
                }
            }
            
            //Save the message in the message log
            $this->saveSMS($recipient,0,$message,$messageid,$messagestatus);
            // // validate later on any returned error 
            return $messagestatus=="Sent"?"success":$errordescription;
        }


        public function saveSMS($customerid,$mobileno,$message,$messageid,$messagestatus){
            $sql="CALL `sp_savesmslog`('{$mobileno}','{$customerid}','{$message}','{$messageid}','{$messagestatus}')";
            $this->getData($sql);
        }
    }
?>