$(document).ready(()=>{
    // declare variables for the HTML objects
    var urlfield=$("#url"),
        apikeyfield=$("#apikey"),
        senderidfield=$("#senderid"),
        clientidfield=$("#clientid"),
        savemsmsconfigurationbutton=$("#savesmsconfiguration"),
        configurationerrordiv=$("#configurationerrordiv"),
        smsconfigform=$(".smsconfig"),
        testsmssenderrordiv=$("#testsmssenderrors"),
        mobilenumberfield=$("#sendto"),
        messagefield=$("#message"),
        sendtestsmsbutton=$("#sendsms"),
        sidebarmenu=$("#settings")
        sidebarmenu.addClass("active")
    // get logged in user
    getLoggedInUser()
    // get sms confirguration stored in the database
    getsmsconfiguration()

    function getsmsconfiguration(){
        $.getJSON(
            "../controllers/settingoperations.php",
            {
                getsmsparameters:true
            },
            (data)=>{
                if(data.length>0){
                    apikeyfield.val(data[0].apikey)
                    senderidfield.val(data[0].senderid)
                    clientidfield.val(data[0].clientid)
                    urlfield.val(data[0].url)
                }else{
                    // show an alert that there is no configuration set
                    configurationerrordiv.html(showAlert('info','Sorry, SMS configuration not set',1))
                }
            }
        )
    }

    // save the sms configuration
    savemsmsconfigurationbutton.on("click",()=>{
        var senderid=senderidfield.val(),
            apikey=apikeyfield.val(),
            clientid=clientidfield.val(),
            url=urlfield.val(),
            errors=""
        // check for blank fields
        if(clientid==""){
            errors="Please provide client id"
            clientidfield.focus()
        }else if(senderid==""){
            errors="Please provide sender id"
            senderidfield.focus()
        }else if(apikey==""){
            errors="Please provide the API key"
            apikeyfield.focus()
        }else if(url==""){
            errors="Please enter URL"
            urlfield.focus()
        }

        if(errors==""){
            // save the sms configuration
            $.post(
                "../controllers/settingoperations.php",
                {
                    savesmsparameter:true,
                    clientid:clientid,
                    senderid:senderid,
                    apikey:apikey,
                    url:url
                },
                (data)=>{
                    if(data=="success"){
                        configurationerrordiv.html(showAlert('success','SMS configuration saved successfully'))
                    }else{
                        configurationerrordiv.html(showAlert('danger',`Sorry, An error occured <br/>${data}`))
                    }
                }
            )
        }else{
            //show the error message generated
            configurationerrordiv.html(showAlert('info',errors))
        }

    })

    smsconfigform.find("input").on("input",()=>{
        configurationerrordiv.html('')
    })

    // send test message
    sendtestsmsbutton.on("click",()=>{
        var mobilenumber=mobilenumberfield.val(),
            message=messagefield.val(),
            errors=""
        // validate blank fields
        if(mobilenumber==""){
            errors="Please provide recipient mobile number"
            mobilenumberfield.focus()
        }else if(message==""){
            errors="Please provide a message for the recipient"
            messagefield.val()
        }

        if(errors==""){
            // send the message
            testsmssenderrordiv.html(showAlert('processing','Sending SMS. Please wait ...',1))
            $.post(
                "../controllers/settingoperations.php",
                {
                    sendsms:true,
                    mobilenumber:mobilenumber,
                    message:message
                },
                (data)=>{
                    data=$.trim(data)
                    if(data=="Success"){
                        testsmssenderrordiv.html(showAlert('success','Test SMS sent successfully'))
                    }else{
                        testsmssenderrordiv.html(showAlert('danger',`Test SMS not sent.<br/>${data}`))
                    }
                }
            )   
        }else{
            // display error messages
            testsmssenderrordiv.html(showAlert('info',errors))
        }
    })
})