$(document).ready(()=>{
    sidebarmenu=$("#recharge")
    sidebarmenu.addClass("active"),
    datefields=$(".datepicker"),
    addpaymentmodal=$("#addpaymentmodal"),
    addpaymentbutton=$("#addpayment"),
    paymenterrors=$("#paymenterrors"),
    paymentdatefield=$("#paymentdate"),
    amountfield=$("#amount"),
    referencefield=$("#reference"),
    paymentmethodfield=$("#paymentmethod"),
    savepaymentbutton=$("#savepayment"),
    filterrechargebutton=$("#filterrechargelog"),
    rechargelist=$("#rechargelogs"),
    startdatefield=$("#startdate"),
    enddatefield=$("#enddate"),
    filtererrors=$("#filtererrors")

    datefields.datepicker({maxDate: new Date()})

    $.datepicker.setDefaults({
        dateFormat: 'dd-M-yy'
    })

    addpaymentbutton.on("click",()=>{
        addpaymentmodal.modal("show")
    })

    savepaymentbutton.on("click",()=>{
        var paymentdate=paymentdatefield.val(),
            paymentmethod=paymentmethodfield.val(),
            referenceno=referencefield.val(),
            amount=amountfield.val(),
            errors="",
            notifications=""
        // check for blank fields
        if(paymentdate==""){
            errors="Please select the payment date"
            paymentdatefield.focus()
        }else if(paymentmethod==""){
            errors="Please select payment method"
            paymentmethodfield.focus()
        }else if(referenceno==""){
            errors="Please provide reference number"
            referencefield.focus()
        }else if(amount=="" || Number(amount)<=0){
            errors="Please provide amount paid"
            amountfield.focus()
        }
        if(errors==""){
            paymenterrors.html(showAlert("processing","Processing. Please wait ...",1))
            $.post(
                "../controllers/rechargeoperations.php",
                {
                    saverecharge:true,
                    paymentdate,
                    referenceno,
                    paymentmode:paymentmethod,
                    amount
                },
                (data)=>{
                    data=$.trim(data)
                    if(data=="success"){
                        notifications="The payment has been saved successfully."
                        paymenterrors.html(showAlert("success",notifications))
                        // clear fields
                        paymentdatefield.val("")
                        paymentmethodfield.val("")
                        referencefield.val("")
                        amountfield.val("")
                    }else if(data=="exists"){
                        notifications="Sorry, the reference number already exists in th system"
                        paymenterrors.html(showAlert("info",notifications))
                    }else{
                        notifications=`Sorry, an error occured ${data}`
                        paymenterrors.html(showAlert("danger",notifications,1))
                    }
                }
            )
        }else{
            paymenterrors.html(showAlert("info",errors))
        }
    })

    filterrechargebutton.on("click",()=>{
        var startdate=startdatefield.val(),
            enddate=enddatefield.val(),
            errors=""
        // check for blank fields
        if(startdate==""){
            errors="Please select start date"
            startdatefield.focus()
        }else if(enddate==""){
            errors="Please select end date"
            enddatefield.focus()
        }
        if(errors==""){
            filtererrors.html(showAlert("processing","Processing. Please wait ...",1))
            $.getJSON(
                "../controllers/rechargeoperations.php",
                {
                    filterrecharge:true,
                    startdate,
                    enddate
                },
                (data)=>{
                    var results="", amount
                    for(var i=0;i<data.length;i++){
                        amount=$.number(data[i].amount)
                        results+=`<tr><td>${Number(i+1)}</td>`
                        results+=`<td>${data[i].paymentdate}`
                        results+=`<td>${data[i].paymentmode}`
                        results+=`<td>${data[i].reference}`
                        results+=`<td>${amount}</tr>`
                    }
                    console.log(results)
                    rechargelist.find("tbody").html(results)
                    filtererrors.html("")
                }
            )
        }else{
            filtererrors.html(showAlert("info",errors))
        }
    })
})